/*************************************************************************************************
 * @file Debug.h
 *
 * @brief This header contains a macro which enables the developer to prompt debug output.
 * In case of Win32 and a debug-configuration, debug messages will be redirected to standard output. 
 * 
 * @author Elmar
 *
 */

/* prevent multiple inclusion */
#ifndef __DEBUG_H
#define __DEBUG_H

#include "stdio.h"

/*use DEBUG/printf only if we run under Win32 in debug configuration*/
# ifdef WIN32
  #ifdef _DEBUG
    # define DEBUG printf
  # else
    # define DEBUG 1 ? 0 : /* nothing */
  #endif
# else
  # define DEBUG 1 ? 0 : /* nothing */
# endif

#endif  /* __DEBUG_H */